function [data,cfg,text_sum] = preprocess_gyro_data(filelist,rate_demod,int_demod)

rate_t = [];
rate_x = [];
rate_y = [];
rate_1f = [];

int_t = [];
int_x = [];
int_y = [];
int_2f = [];

for i = 1:length(filelist)
    try
        load(filelist{i});
    catch
        warning(sprintf('\nBad Data in file: %s',filelist{i}))
        continue
    end
    
    lost_packets = sum(dev3336.stats.datastream.packetslost.value)>0; %Boolean signalling if any packets were lost
    rate_dataloss = dev3336.demods(rate_demod).sample.time.dataloss || ...
        dev3336.demods(rate_demod).sample.time.blockloss || ...
        dev3336.demods(rate_demod).sample.time.invalidtimestamp;
    int_dataloss = dev3336.demods(int_demod).sample.time.dataloss || ...
        dev3336.demods(int_demod).sample.time.blockloss || ...
        dev3336.demods(int_demod).sample.time.invalidtimestamp;
    file_dataloss = lost_packets || int_dataloss || rate_dataloss;
    
    if file_dataloss
        warning(sprintf('Data loss in file: %s',filelist{i}))
    else
        fprintf('\nData good in file: %s\n',filelist{i});
    end
    
    rate_t = [rate_t; dev3336.demods(rate_demod).sample.timestamp'];
    int_t = [int_t; dev3336.demods(int_demod).sample.timestamp'];
    
    rate_x = [rate_x; dev3336.demods(rate_demod).sample.x'];
    int_x = [int_x; dev3336.demods(int_demod).sample.x'];
    
    rate_y = [rate_y; dev3336.demods(rate_demod).sample.y'];
    int_y = [int_y; dev3336.demods(int_demod).sample.y'];
    
    rate_1f = [rate_1f; dev3336.demods(rate_demod).sample.frequency'];
    int_2f = [int_2f; dev3336.demods(int_demod).sample.frequency'];
    
    if i == 1;
        adc_select = dev3336.demods(rate_demod).adcselect.value || dev3336.demods(int_demod).adcselect.value; %Boolean signalling adc selection
%         bypass = dev3336.demods(rate_demod).bypass.value || dev3336.demods(int_demod).bypass.value; %Boolean signalling bypass
        enabled =  dev3336.demods(rate_demod).enable.value && dev3336.demods(int_demod).enable.value; %Boolean signalling channel enable
        
        rate_harmonic = dev3336.demods(rate_demod).harmonic.value;
        int_harmonic = dev3336.demods(int_demod).harmonic.value;
        
        if rate_harmonic ~= 1;
            warning('Rate Detection Harmonic not equal to 1 - Check Settings')
        end
        if int_harmonic ~= 2;
            warning('Intensity Detection Harmonic not equal to 2 - Check Settings')
        end
        
        rate_filtord = dev3336.demods(rate_demod).order.value;
        int_filtord = dev3336.demods(int_demod).order.value;
        
        rate_tc = dev3336.demods(rate_demod).timeconstant.value;
        int_tc = dev3336.demods(int_demod).timeconstant.value;
        
        rate_sr = dev3336.demods(rate_demod).rate.value;
        int_sr = dev3336.demods(int_demod).rate.value;
        if rate_sr ~= int_sr
            warning('Inconsistent sample rates between rate and intensity demod - check LIA setttings')
        else
            sample_rate = rate_sr;
        end
        
        rate_sincenable = dev3336.demods(rate_demod).sinc.value;
        int_sincenable = dev3336.demods(int_demod).sinc.value;
        
        rate_phaseoff = dev3336.demods(rate_demod).phaseshift.value;
        int_phaseoff = dev3336.demods(int_demod).phaseshift.value;
    else
        if adc_select ~= (dev3336.demods(rate_demod).adcselect.value || dev3336.demods(int_demod).adcselect.value)
            warning(sprintf('ADC select changed in file: %s',filelist{i}))
        end
%         if bypass ~= (dev3336.demods(rate_demod).bypass.value || dev3336.demods(int_demod).bypass.value)
%             warning(sprintf('Bypass changed in file: %s',filelist{i}))
%         end
        if enabled ~=  (dev3336.demods(rate_demod).enable.value && dev3336.demods(int_demod).enable.value)
            warning(sprintf('Channel Enable changed in file: %s',filelist{i}))
        end
        if rate_harmonic ~= dev3336.demods(rate_demod).harmonic.value
            warning(sprintf('Rate Detection Harmonic changed in file: %s',filelist{i}))
        end
        if int_harmonic ~= dev3336.demods(int_demod).harmonic.value
            warning(sprintf('Intensity Detection Harmonic changed in file: %s',filelist{i}))
        end
        if rate_filtord ~= dev3336.demods(rate_demod).order.value
            warning(sprintf('Rate Filter Order changed in file: %s',filelist{i}))
        end
        if int_filtord ~= dev3336.demods(int_demod).order.value
            warning(sprintf('Intensity Filter Order changed in file: %s',filelist{i}))
        end
        if rate_tc ~= dev3336.demods(rate_demod).timeconstant.value
            warning(sprintf('Rate Filter Time Constant changed in file: %s',filelist{i}))
        end
        if int_tc ~= dev3336.demods(int_demod).timeconstant.value
            warning(sprintf('Intensity Filter Time Constant changed in file: %s',filelist{i}))
        end
        if rate_sr ~= dev3336.demods(rate_demod).rate.value
            warning(sprintf('Rate Sample Frequency changed in file: %s',filelist{i}))
        end
        if int_sr ~= dev3336.demods(int_demod).rate.value
            warning(sprintf('Intensity Sample Frequency changed in file: %s',filelist{i}))
        end
        if rate_sincenable ~= dev3336.demods(rate_demod).sinc.value
            warning(sprintf('Rate Sinc Enable changed in file: %s',filelist{i}))
        end
        if int_sincenable ~= dev3336.demods(int_demod).sinc.value
            warning(sprintf('Intensity Sinc Enable changed in file: %s',filelist{i}))
        end
        if rate_phaseoff ~= dev3336.demods(rate_demod).phaseshift.value
            warning(sprintf('Rate LIA Phase changed in file: %s',filelist{i}))
        end
        if int_phaseoff ~= dev3336.demods(int_demod).phaseshift.value
            warning(sprintf('Intensity LIA Phase changed in file: %s',filelist{i}))
        end
    end
    
    clear dev3336
    
end

line_index = 1;
text_sum = cell(1,1);

if ~isequal(rate_t,int_t)
    warning('Inconsistent rate and intensity timestamps')
end
t = rate_t;

if length(unique(diff(t))) > 1 
    warning('Sample Rate Discontinuity - Frame shift somewhere in data')
end

sinc_text = {'Off';'On'};

text_sum{line_index,1} = ['F_s = ' num2str(rate_sr,'%6f') ' Hz | \theta_{Rate} = ' num2str(rate_phaseoff,'%6f') ' | \theta_{Int} = ' num2str(int_phaseoff,'%6f') ''];
line_index =  line_index + 1;

% text_sum{line_index,1} = sprintf('Rate Filter: %s s | Order = %s | Sinc %s',num2str(rate_tc,'%6f'),num2str(rate_filtord),sinc_text{rate_sincenable+1});
% line_index =  line_index + 1;
% 
% text_sum{line_index,1} = sprintf('Intensity Filter: %s s | Order = %s | Sinc %s',num2str(int_tc,'%6f'),num2str(int_filtord),sinc_text{int_sincenable+1});
% line_index =  line_index + 1;

text_sum{line_index,1} = sprintf('Rate Filter: %s s | Order = %s | Sinc %s --- Intensity Filter: %s s | Order = %s | Sinc %s',...
    num2str(rate_tc,'%6f'),num2str(rate_filtord),sinc_text{rate_sincenable+1},...
    num2str(int_tc,'%6f'),num2str(int_filtord),sinc_text{int_sincenable+1});
line_index =  line_index + 1;

if adc_select
    ADC_line = 'ADC Select ON';
else
    ADC_line = 'ADC Select OFF';
end

% if bypass
%     bypass_line = 'Bypass Enabled';
% else
%     bypass_line = 'Bypass Disabled';
% end

if enabled
    chan_line = 'Channels Enabled';
else
    chan_line = 'Channels Disabled';
end

text_sum{line_index,1} = [chan_line ' | ' ADC_line]; %' | ' bypass_line];

%disp(text_sum)

cfg.sample_rate = rate_sr;
cfg.rate_phaseoff = rate_phaseoff;
cfg.int_phaseoff = int_phaseoff;
cfg.rate_tc = rate_tc;
cfg.int_tc = int_tc;
cfg.rate_filtord = rate_filtord;
cfg.int_filtord = int_filtord;
cfg.rate_sincenable = rate_sincenable;
cfg.int_sincenable = int_sincenable;

data.N = numel(rate_x);
t_vec = 0:(data.N-1);
data.t = (t_vec').*(1./rate_sr);
data.xf1 = rate_x;
data.yf1 = rate_y;
data.f1 = rate_1f;
data.xf2 = int_x;
data.yf2 = int_y;
data.f2 = int_2f;

end